definition module directory_structure;

import StdEnv;
import DynID;
import StdMaybe;
/* Directory structure:
**
** There's is a root-directory called 'Dynamics'. This directory
** contains the following file:
** - DynamicLinker.exe
**
** And the following subdirectories:
** - libraries
** - lazy dynamics
** - conversion
** - utilities
*/

//1.3
from StdString import String;
from StdFile import FileSystem;
//3.1

/*2.0
from StdFile import class FileSystem, ::Files;
0.2*/


ds_generate_library_name :: !String !String !*env -> (!String,!*env) | FileSystem env;

ds_create_directory :: !{#.Char} !{#.Char} !*a -> *(.(Maybe {#Char}),*a) | FileSystem a;

APPEND_LIBRARY_PATH ddir id :== ddir +++ "\\" +++ DS_LIBRARIES_DIR +++ "\\" +++ id;

APPEND_LAZY_DYNAMIC_PATH ddir id :== ddir +++ "\\" +++ DS_SYSTEM_DYNAMICS_DIR +++ "\\" +++ id +++ ".sysdyn";